/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import novamachina.exnihilosequentia.client.render.AbstractModBlockRenderer;
import novamachina.exnihilosequentia.client.render.UVLocation;
import novamachina.exnihilosequentia.client.render.VertexLocation;
import novamachina.exnihilosequentia.common.blockentity.crucible.BaseCrucibleEntity;
import novamachina.exnihilosequentia.common.utility.Color;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

public class CrucibleRender
extends AbstractModBlockRenderer<BaseCrucibleEntity> {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    public CrucibleRender(@Nonnull BlockEntityRendererProvider.Context rendererDispatcher) {
    }

    public static void register(@Nonnull BlockEntityType<? extends BaseCrucibleEntity> tileTileEntityType) {
        logger.debug("Register crucible renderer, Type" + tileTileEntityType);
        BlockEntityRenderers.m_173590_(tileTileEntityType, CrucibleRender::new);
    }

    public void render(@Nonnull BaseCrucibleEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        ResourceLocation solidTexture = tileEntity.getSolidTexture();
        Fluid fluid = tileEntity.getFluid();
        ResourceLocation fluidTexture = fluid != null ? fluid.getAttributes().getStillTexture() : null;
        Color fluidColor = fluid != null ? new Color(fluid.getAttributes().getColor()) : Color.INVALID_COLOR;
        Color blockColor = this.getBlockColor(solidTexture, tileEntity);
        this.renderFluid(tileEntity, matrixStack, buffer, combinedLightIn, fluidTexture, fluidColor, new UVLocation(0.0f, 1.0f));
        if (solidTexture != null) {
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation(solidTexture.m_135827_(), "block/" + this.resolveTexture(solidTexture.m_135815_())));
            float fillAmount = 0.75f * Math.min(tileEntity.getSolidProportion(), 1.0f) - 0.005f;
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            this.add(builder, matrixStack, new VertexLocation(0.0f, 0.25f + fillAmount, 1.0f), new UVLocation(sprite.m_118409_(), sprite.m_118412_()), blockColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(1.0f, 0.25f + fillAmount, 1.0f), new UVLocation(sprite.m_118410_(), sprite.m_118412_()), blockColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(1.0f, 0.25f + fillAmount, 0.0f), new UVLocation(sprite.m_118410_(), sprite.m_118411_()), blockColor, combinedLightIn);
            this.add(builder, matrixStack, new VertexLocation(0.0f, 0.25f + fillAmount, 0.0f), new UVLocation(sprite.m_118409_(), sprite.m_118411_()), blockColor, combinedLightIn);
            matrixStack.m_85849_();
        }
    }

    @Nonnull
    private Color getBlockColor(ResourceLocation solidTexture, BaseCrucibleEntity tileEntity) {
        if (solidTexture != null && solidTexture.toString().contains("leaves") && tileEntity.m_58904_() != null) {
            return new Color(((Biome)tileEntity.m_58904_().m_204166_(tileEntity.m_58899_()).m_203334_()).m_47542_());
        }
        return Color.WHITE;
    }
}

